<?php 
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo https://www.geecom.org/index.php?id=34&alias=linee-guida-per-l%2527uso-del-logo-geecom
    * 
    * Classe che definisce le etichette
    */

    class Etichetta {
        private $db;
        private $id;
        private $nome;
        private $tipo;
        private $dataCreazione;
        
        function __construct($db, $id) {
            $this->db = $db;
            $this->id = $id;
            $this->nome = "";
            $this->tipo = "";
            $this->dataCreazione = "";
        }
        
        function crea() {
            $dataCreazione = date("Y-m-d");
            $queryControlloTagEsistente ="SELECT * FROM geecD_etichette WHERE nome LIKE '$this->nome'";
            $ris = $this->db->eseguiQueryLettura($queryControlloTagEsistente);
            if($ris->num_rows == 0) {
                $query = "INSERT INTO geecD_etichette VALUES(NULL,'$this->nome','$this->tipo','$dataCreazione')";
                $this->id = $this->db->eseguiQueryCreazione($query);
                return $this->id;
            }
            else {
                return -1;
            }
        }

        function modifica() {
            $query = "UPDATE geecD_etichette SET nome='$this->nome', descrizione = $this->descrizione WHERE id = $this->id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function elimina() {
            $this->db->eseguiQueryCancellazione("geecD_etichette",$this->id);
        }
         
        function stampaPulsanteEtichetta() {
            $datiEtichetta = $this->db->leggiSingolaRiga("geecD_etichette",$this->id);
            $nomeEscape    = filter_var($datiEtichetta["nome"],FILTER_SANITIZE_ADD_SLASHES);
            
            echo"<div id=\"divEtichetta{$this->id}\" class=\"d-inline-block mr-2 mb-2\">
                    <button type=\"button\" class=\"btn btn-outline-primary round\" onclick=\"eliminaEtichetta({$this->id})\">{$nomeEscape}<i class=\"fas fa-times ml-2\"></i></button>
                </div>";
        }
         
        function stampaPulsanteEtichettaPrimary() {
            $datiEtichetta = $this->db->leggiSingolaRiga("geecD_etichette",$this->id);
            $nomeEscape    = filter_var($datiEtichetta["nome"],FILTER_SANITIZE_ADD_SLASHES);
            
            echo"<div id=\"divEtichetta{$this->id}\" class=\"d-inline-block mr-2 mb-2\">
                    <button type=\"button\" class=\"btn btn-primary btn-sm round\" onclick=\"eliminaAssociazioneEtichetta({$this->id})\">{$nomeEscape}<i class=\"fas fa-times ml-2\"></i></button>
                </div>";
        }
        
        function stampaRigaEtichetta() {
            $datiEtichetta = $this->db->leggiSingolaRiga("geecD_etichette",$this->id);
            $nomeEscape    = filter_var($datiEtichetta["nome"],FILTER_SANITIZE_ADD_SLASHES);
            $numeroDocumenti = $this->db->contaRigheTabella("geecD_associazioneEtichetteDocumenti",array("idEtichetta"=>$datiEtichetta["id"]));
            echo"<div id=\"divEtichetta{$datiEtichetta["id"]}\" class=\"col-sm-6 col-lg-4\">
                <div class=\"card-body mb-3 py-1 px-2 bg-light border rounded d-sm-flex justify-content-between align-items-center text-center\">
                    <div class=\"mb-1 mb-sm-0 text-muted w-50 text-left\">
                        <p class=\"mb-0\"><em><strong>{$datiEtichetta["nome"]}</strong></em>  </p>
                        <small><em>$numeroDocumenti documenti</em>  </small>
                    </div>
                    <div class=\"azioni d-flex align-items-center justify-content-end\">
                        <div class=\"btn-group\" role=\"group\" aria-label=\"Basic example\">
                            <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Visualizza documenti\" onclick=\"location.href='elencoDocumenti.php?etichetta={$datiEtichetta["id"]}';\"><i class=\"fas fa-users\"></i></button>
                            <button type=\"button\" class=\"btn btn-light elimina\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Elimina\" onclick=\"eliminaGruppo({$datiEtichetta["id"]},'$nomeEscape')\" ><i class=\"far fa-trash-alt\"></i></button>
                        </div>
                   </div>
                </div>
            </div>";
        }
        
        // getter & setter
        
        function getId() {
            return $this->id;
        }

        function getTipo() {
            return $this->tipo;
        }
        
        function getNome() {
            return $this->nome;
        }
        
        function getDataCreazione() {
            return $this->dataCreazione;
        }

        function setId($id) {
            $this->id = $id;
        }

        function setTipo($tipo) {
            $this->tipo = $tipo;
        }
        
        function setNome($nome) {
            $this->nome = $nome;
        }
        
        function setDataCreazione($dataCreazione) {
            $this->dataCreazione = $dataCreazione;
        }
    }
